package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.Rules;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Strength;
import com.hero.objects.enhancers.Enhancer;
import com.hero.objects.martialarts.ExtraDamageClasses;
import com.hero.objects.martialarts.Maneuver;
import com.hero.objects.martialarts.RangedDamageClasses;
import com.hero.objects.martialarts.WeaponElement;
import com.hero.ui.widgets.PopupMessage;
import com.hero.util.Constants;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class EquipmentList extends GenericObjectList {

	private static final long serialVersionUID = 465955563511162593L;

	public EquipmentList() {
		super("Equipment", "Cost", "Equipment", "END", HeroDesigner
				.getActiveHero().getEquipment());
	}

	@Override
	public void addObject(GenericObject o) {
		o.setIsEquipment(true);
		if (HeroDesigner.getActiveHero().isPrefab()) {
			super.addObject(o);
			return;
		}
		o.setPower(true);
		boolean ret = true;
		boolean warned = false;
		Rules rules = HeroDesigner.getActiveHero().getRules();
		if (!warned && (rules.getAttackAPMaxResponse() > Rules.IGNORE)
				&& o.getTypes().contains("ATTACK")) {
			double active = o.getActiveCost();
			if (active > rules.getAttackAPMaxValue()) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This Attack exceeds the maximum Active Points for an Attack set in the campaign rules.",
								rules.getAttackAPMaxResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getAttackAPMaxResponse() == Rules.WARN;
			}
		}
		if (!warned && (rules.getDefenseAPMaxResponse() > Rules.IGNORE)
				&& o.getTypes().contains("DEFENSE")) {
			double active = o.getActiveCost();
			if (active > rules.getDefenseAPMaxValue()) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This Defense ability exceeds the maximum Active Points for a Defense ability set in the campaign rules.",
								rules.getDefenseAPMaxResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getDefenseAPMaxResponse() == Rules.WARN;
			}
		}
		if (!warned && (rules.getEquipmentCostResponse() > Rules.IGNORE)) {
			// check total cost of Equipment:
			double cost = 0d;
			for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment()
					.size(); i++) {
				GenericObject e = HeroDesigner.getActiveHero().getEquipment()
						.get(i);
				cost += e.getTotalPrice();
			}
			if ((o.getPrice() > 0)
					&& (o.getTotalPrice() + cost > rules
							.getEquipmentCostValue())) {
				PopupMessage popup = PopupMessage.getInstance(HeroDesigner
						.getAppFrame(), this,
						"This purchase puts you over the max total value (in "
								+ rules.getEquipmentCostUnits()
								+ ") set in the campaign rules.", rules
								.getEquipmentCostResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getEquipmentCostResponse() == Rules.WARN;
			}
		}
		if (!warned
				&& o.isCarried()
				&& (HeroDesigner.getActiveHero().getCharacteristic(
						Constants.STR) != null)) {
			// check total weight of Equipment:
			double weight = o.getTotalWeight();
			for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment()
					.size(); i++) {
				GenericObject e = HeroDesigner.getActiveHero().getEquipment()
						.get(i);
				if (e.isCarried()) {
					weight += e.getTotalWeight();
				}
			}
			Strength str = (Strength) HeroDesigner.getActiveHero()
					.getCharacteristic(Constants.STR);
			double liftVal1 = 25d;
			double liftVal2 = 25d;
			double pow1 = str.getPrimaryValue() / 5d;
			double pow2 = str.getSecondaryValue() / 5d;
			if (pow1 > 0) {
				liftVal1 = Math.pow(2, pow1) * liftVal1;
			} else {
				liftVal1 = liftVal1 / Math.pow(2, Math.abs(pow1));
			}
			if (pow2 > 0) {
				liftVal2 = Math.pow(2, pow2) * liftVal2;
			} else {
				liftVal2 = liftVal2 / Math.pow(2, Math.abs(pow2));
			}

			if (!HeroDesigner.getInstance().getPrefs().isMetric()) {
				liftVal1 = liftVal1 / .4535924;
				liftVal2 = liftVal2 / .4535924;
			}

			if (weight > liftVal1) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This purchase puts the total weight of Equipment carried by the character over the amount he can lift (primary STR).",
								true);
				popup.setVisible(true);
				warned = true;
			} else if (weight > liftVal2) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This purchase puts the total weight of Equipment carried by the character over the amount he can lift (secondary STR).",
								true);
				popup.setVisible(true);
				warned = true;
			}
		}

		if (ret) {
			super.addObject(o);
		}
	}

	@Override
	protected boolean checkPaste() {
		GenericObject copy = HeroDesigner.getCopyBuffer();
		if (copy == null) {
			return false;
		} else {
			if ((copy instanceof Maneuver)
					|| (copy instanceof ExtraDamageClasses)
					|| (copy instanceof RangedDamageClasses)
					|| (copy instanceof WeaponElement)) {
				return false;
			} else if (copy instanceof Enhancer) {
				return false;
			} else if (copy instanceof com.hero.objects.List) {
				com.hero.objects.List list = (com.hero.objects.List) copy;
				for (int i = 0; i < list.getObjects().size(); i++) {
					if ((list.getObjects().get(i) instanceof Maneuver)
							|| (list.getObjects().get(i) instanceof ExtraDamageClasses)
							|| (list.getObjects().get(i) instanceof RangedDamageClasses)
							|| (list.getObjects().get(i) instanceof WeaponElement)) {
						return false;
					}
				}
				return true;
			} else {
				return true;
			}
		}
	}

	@Override
	protected boolean checkReplace(GenericObject replacement,
			GenericObject replacee) {
		replacement.setIsEquipment(true);
		if (HeroDesigner.getActiveHero().isPrefab()) {
			return true;
		}
		boolean ret = true;
		boolean warned = false;
		Rules rules = HeroDesigner.getActiveHero().getRules();
		if (!warned && (rules.getAttackAPMaxResponse() > Rules.IGNORE)
				&& replacement.getTypes().contains("ATTACK")) {
			double active = replacement.getActiveCost();
			if ((active > rules.getAttackAPMaxValue())
					&& (active > replacee.getActiveCost())) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This Attack exceeds the maximum Active Points for an Attack set in the campaign rules.",
								rules.getAttackAPMaxResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getAttackAPMaxResponse() == Rules.WARN;
			}
		}
		if (!warned && (rules.getDefenseAPMaxResponse() > Rules.IGNORE)
				&& replacement.getTypes().contains("DEFENSE")) {
			double active = replacement.getActiveCost();
			if ((active > rules.getDefenseAPMaxValue())
					&& (active > replacee.getActiveCost())) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This Defense ability exceeds the maximum Active Points for a Defense ability set in the campaign rules.",
								rules.getDefenseAPMaxResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getDefenseAPMaxResponse() == Rules.WARN;
			}
		}
		if (!warned && (rules.getEquipmentCostResponse() > Rules.IGNORE)
				&& (replacement.getTotalPrice() > replacee.getTotalPrice())) {
			// check total cost of Equipment:
			double cost = 0d;
			for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment()
					.size(); i++) {
				GenericObject e = HeroDesigner.getActiveHero().getEquipment()
						.get(i);
				cost += e.getTotalPrice();
			}
			if ((replacement.getPrice() > 0)
					&& (replacement.getTotalPrice() + cost > rules
							.getEquipmentCostValue())) {
				PopupMessage popup = PopupMessage.getInstance(HeroDesigner
						.getAppFrame(), this,
						"This purchase puts you over the max total value (in "
								+ rules.getEquipmentCostUnits()
								+ ") set in the campaign rules.", rules
								.getEquipmentCostResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getEquipmentCostResponse() == Rules.WARN;
			}
		}
		if (!warned
				&& replacement.isCarried()
				&& ((replacement.getTotalWeight() > replacee.getTotalWeight()) || !replacee
						.isCarried())
				&& (HeroDesigner.getActiveHero().getCharacteristic(
						Constants.STR) != null)) {
			// check total weight of Equipment:
			double weight = replacement.getTotalWeight();
			for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment()
					.size(); i++) {
				GenericObject e = HeroDesigner.getActiveHero().getEquipment()
						.get(i);
				if (e.isCarried()) {
					weight += e.getTotalWeight();
				}
			}
			Strength str = (Strength) HeroDesigner.getActiveHero()
					.getCharacteristic(Constants.STR);
			double liftVal1 = 25d;
			double liftVal2 = 25d;
			double pow1 = str.getPrimaryValue() / 5d;
			double pow2 = str.getSecondaryValue() / 5d;
			if (pow1 > 0) {
				liftVal1 = Math.pow(2, pow1) * liftVal1;
			} else {
				liftVal1 = liftVal1 / Math.pow(2, Math.abs(pow1));
			}
			if (pow2 > 0) {
				liftVal2 = Math.pow(2, pow2) * liftVal2;
			} else {
				liftVal2 = liftVal2 / Math.pow(2, Math.abs(pow2));
			}

			if (!HeroDesigner.getInstance().getPrefs().isMetric()) {
				liftVal1 = liftVal1 / .4535924;
				liftVal2 = liftVal2 / .4535924;
			}

			if (weight > liftVal1) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This purchase puts the total weight of Equipment carried by the character over the amount he can lift (primary STR).",
								true);
				popup.setVisible(true);
				warned = true;
			} else if (weight > liftVal2) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This purchase puts the total weight of Equipment carried by the character over the amount he can lift (secondary STR).",
								true);
				popup.setVisible(true);
				warned = true;
			}
		}
		return ret;
	}
}